wtd.median.group <- function (x, w, g, all = TRUE) {
  v <- by(cbind(x, w), g,
          function(a) wtd.median(a[,1], a[,2]))

  if (all) {
    va <- data.frame(as.vector(v), row.names=rownames(v))
    names(va) <- 'w'
    va <- merge(data.frame(g), va, by.x='g', by.y='row.names', all.x=TRUE)
    return(as.vector(va$w))
  }
  else
    return(as.vector(v))
}


wtd.median <- function (x, w, na.rm = FALSE) {
  # I copied that function from library(limma)
  # calculates the weighted median
  
  if (missing(w))
    w <- rep.int(1, length(x))
  else {
    if (length(w) != length(x))
      stop("'x' and 'w' must have the same length")
    if (any(is.na(w))) 
      stop("NA weights not allowed")
    if (any(w < 0)) 
      stop("Negative weights not allowed")
  }
  if (is.integer(w))
    w <- as.numeric(w)
  if (na.rm) {
    w <- w[i <- !is.na(x)]
    x <- x[i]
  }
  if (all(w == 0)) {
    warning("All weights are zero")
    return(NA)
  }
  o <- order(x)
  x <- x[o]
  w <- w[o]
  p <- cumsum(w)/sum(w)
  n <- sum(p < 0.5)

  if (p[n + 1] > 0.5)
    x[n + 1]
  else
    (x[n + 1] + x[n + 2])/2
}


