# Mostly like the first example, but this time we study
# Italy and Germany only and use Benoit/Laver positions

library(RSQLite)
source('functions.R')

con = dbConnect(dbDriver("SQLite"), dbname="../data/parlgov-public.db")
sql =  "
SELECT c.*, bl.leftright AS blleftright FROM
(SELECT * FROM view_cabinet_formation WHERE countryID in (276, 380)) AS c
LEFT OUTER JOIN (SELECT countryID, partyID, benoit FROM party) AS p
    ON c.countryID=p.countryID AND c.partyID = p.partyID
LEFT OUTER JOIN (SELECT id, leftright FROM foreign_party_experts_2006_benoit_laver_position) AS bl
    ON p.benoit = bl.id
"
cab = dbGetQuery(con,sql)


# Calculate some of the values not in the ParlGov database

cab$shareseats = cab$seats / cab$seatsparltotal

cab$cabIDunique = as.integer(paste(cab$countryID, cab$cabID, sep=''))
cab$median <- wtd.median.group(cab$blleftright, cab$shareseats, cab$cabIDunique)
cab$median <- as.integer(cab$median == cab$blleftright)

write.csv(cab, "cabinet-formation-ita-ger-bl.csv", na='', row.names = FALSE)


# Some calculations to answer the question raised at the beginning

m1 = glm(formula = cabparty ~ shareseats,
         family = binomial(link = "logit"), data=cab)
summary(m1)

m2 = glm(formula = cabparty ~ shareseats + median + shareseats*median,
         family = binomial(link = "logit"), data=cab)
summary(m2)

closeAllConnections()
dbDisconnect(con)
