# if you run the script for the first time and RSQLite is not installed,
# install RSQLite by uncommenting next line
#install.packages("RSQLite", dependencies = TRUE, repos="http://cran.r-project.org")

  # loading RSQLite package
library(RSQLite)
  # loading functions
source('functions.R')

  # opening interface to database and fetching cabinet data from ParlGov view
con = dbConnect(dbDriver("SQLite"), dbname="../data/parlgov-public.db")
cab = dbGetQuery(con, 'SELECT * FROM view_cabinet_formation')

# Calculate some of the values not in the ParlGov database

  # calculating seat share is simple
cab$shareseats = cab$seats / cab$seatsparltotal

  # we need a unique identifier for cabinets for the next function
cab$cabIDunique = as.integer(paste(cab$countryID, cab$cabID, sep=''))
  # now we calculate the value of the median party in the left/right dimension
  # the function 'wtd.median.group' is provided in file 'functions.R'
cab$median <- wtd.median.group(cab$leftright, cab$shareseats, cab$cabIDunique)
  # convert the numerical value of 'median' into a dummy variable
cab$median <- as.integer(cab$median == cab$leftright)

write.csv(cab, "cabinet-formation.csv", na='', row.names = FALSE)


# Some calculations to answer the question raised at the beginning

m1 = glm(formula = cabparty ~ shareseats,
         family = binomial(link = "logit"), data=cab)
summary(m1)

m2 = glm(formula = cabparty ~ shareseats + median + shareseats*median,
         family = binomial(link = "logit"), data=cab)
summary(m2)

closeAllConnections()
dbDisconnect(con)
