SELECT
-- information from 'country' table
countryshort, countryname, euAccessionDate,
-- variables from 'info tables' ('ep_info', 'parl_info' and 'cab_info')
epElectionDate, electionDate, startingDate AS governmentFormationDate,
-- variables from 'party' table
ep.partyID AS partyID, partyshort, partyorg, partyname, pa.name AS partyfamily,
-- create dummy for governing parties from 'cab_party' table
CASE WHEN cp.partyID IS NOT NULL THEN 1 ELSE 0 END AS government,
-- EP election results from table 'ep_data'
ep.pervote AS eppervote,
-- results from national election, table 'parl_data'
pd.pervote AS pervote,
-- party positions from 'view_calc_party_position'
papos.leftright AS leftright, papos.eu AS eu

FROM

-- first we have to find out wich EP election (epID), national election (parlID) and cabinet (cabID) are related
(SELECT countryID, epID, epElectionDate, parlID, electionDate,
        MAX(cabID) AS cabID, MAX(startingDate) AS startingDate 
   FROM
   (SELECT countryID, epID, epElectionDate,
           MAX(parlID) AS parlID, MAX(electionDate) AS electionDate 
       FROM
       ((SELECT epID, electionDate epElectionDate FROM ep_info)
         JOIN 
         (SELECT DISTINCT epID, countryID FROM ep_data)
          USING (epID)
       )
   -- add date and parlID of most recent national election
   LEFT OUTER JOIN 
      (SELECT countryID, parlID, electionDate FROM parl_info)
   -- merge by country and select only the most recent national election
   USING (countryID)
   WHERE epElectionDate >= electionDate
   GROUP BY countryID, epID
   )
   -- add observations for parties that are in government at the time of EP elections
   LEFT OUTER JOIN cab_info
   USING (countryID)
   WHERE epElectionDate >= startingDate
   GROUP BY countryID, epID
) AS info

-- add results of EP elections
JOIN  ep_data AS ep 
USING (epID, countryID)

-- data data for results of national elections
LEFT OUTER JOIN
   (SELECT * FROM parl_data
        -- use only EU countries only to improve performance (non-EU countries have no match)
        WHERE countryID in
           (SELECT countryID FROM country WHERE euAccessionDate >= '1958-01-01')
    ) AS pd
ON info.countryID=pd.countryID AND info.parlID=pd.parlID AND ep.partyID=pd.partyID

-- data data for results of national elections
LEFT OUTER JOIN
   (SELECT * FROM cab_party
        -- use only EU countries only to improve performance (non-EU countries have no match)
        WHERE countryID in
           (SELECT countryID FROM country WHERE euAccessionDate >= '1958-01-01')
    ) AS cp
ON info.countryID=cp.countryID AND info.cabID=cp.cabID AND ep.partyID=cp.partyID

-- add party information
LEFT OUTER JOIN
   (SELECT * FROM party
     LEFT OUTER JOIN party_family USING (familyID)
    ) AS pa
ON info.countryID=pa.countryID AND ep.partyID=pa.partyID

-- add country information
JOIN country AS co ON info.countryID=co.countryID

-- adding party positions -- we use ParlGov mean positions from table 'view_calc_party_position'
LEFT OUTER JOIN view_calc_party_position AS papos
ON info.countryID=papos.countryID AND ep.partyID=papos.partyID

-- order results by EP election, country and number of votes
ORDER BY info.epID, countryshort, ep.pervote DESC

