library(RSQLite)

con <- dbConnect(dbDriver("SQLite"), dbname="../../data/parlgov-public.db")

sql <- readLines('ep-second-order.sql')
ep <- dbGetQuery(con, paste(sql, collapse='\n'))

write.csv(ep, "ep-second-order-from-db.csv", na='', row.names = FALSE)

# REPLICATION MODEL 7 FROM HIX/MARCH

# Creating Hix/March Data and Variables

# removing new member states from Central- and Eastern Europe
ep <- ep[ep$euAccessionDate < '2001-01-01', ]
# removing parties with no results (pervote) for EP or national election
ep <- ep[!is.na(ep$eppervote) & !is.na(ep$pervote), ]
# removing parties with less than 1% of national or ep vote
ep <- ep[ep$eppervote > 0.01 & ep$pervote > 0.01, ]

attach(ep)

# create variable 'gain' for change in vote share
gain <- eppervote - pervote
# we approximate 'early' by using one year differences only
early <- as.integer(as.Date(epElectionDate, "%Y-%m-%d")
                    - as.Date(electionDate, "%Y-%m-%d")
                    < 365)
size <- pervote
size2 <- pervote^2
size3 <- pervote^3
sizegovernment <- size*government
# calculating left/right and eu extremism variables
leftrightExtr <- (leftright-10)^2
euExtr <- (eu-10)^2
# we skip 'new party' this has to be coded manually

# replicating Model 7
summary(lm(gain ~ size + size2 + size3
           + sizegovernment + early + government*early
           + leftright + leftrightExtr + eu + euExtr ) )

closeAllConnections()
dbDisconnect(con)
