# import from standard library
import os
import re
from urllib import urlopen, urlretrieve
# import from  BeautifulSoup file provided in folder 
# (source: http://www.crummy.com/software/BeautifulSoup )
from BeautifulSoup import *

# definde base url
url = 'http://elezionistorico.interno.it/'

# download index file for election results
f = urlopen(url + 'index.php?tp=C')
index = f.read()

# find all links to pages with election results
elec = re.findall('area\.php\?tp=C&dt=\d\d/\d\d/\d{4}', index)

# create csv folder if not existing
if not os.path.isdir('html'):
    os.mkdir('html')

# loop over list of pages and download every page into csv folder
for e in elec:
    print 'retrieving: ', e

    # there is one page in between that provides the list to the data page
    f = urlopen(url + e)
    t = f.read()
    # find link to data page
    u = re.findall('"liste.+?"', t)
    # copy data page
    urlretrieve(url + u[-1][1:-1], 'html/' + e.split('/')[-1] + '.html')

