# read data sources
mp <- read.csv("mp-bio.csv", as.is=TRUE)
mep <- read.csv("mep-bio.csv", as.is=TRUE)

# create new variable in mep data set
mp$name <- paste(mp$firstname, mp$lastname)

# merge the to data sets
out <- merge(mep, mp, by='name', all.x=TRUE)

# limit to new data set to match name and ids only
out <- out[,c('name', 'id.x', 'id.y')]
names(out) <- c('name', 'mepid', 'mpid')

# write output into csv file
write.csv(out, "mep-mp-merge-R.csv", na='', row.names = FALSE)
