import csv
from febrl.stringcmp import lcs, permwinkler

# read data files from csv files into list of dictionaries

csvRead = csv.DictReader(open('mp-bio.csv'))
mpall = [dict(zip(r.keys(),r.values())) for r in csvRead]

csvRead = csv.DictReader(open('mep-bio.csv'))
mepall = [dict(zip(r.keys(),r.values())) for r in csvRead]

# open csv file for results and write header 
f = open('mep-mp-linked-py.csv', 'w')
f.write('mepid,name,dist,mpid,name\n')

for mep in mepall:
    # initialize values for loop
    maxdist = 0.0
    mpmatch = None

    # create lowercase string from name and birthplace
    mepname = (mep['name'] + ' -- ' + mep['bornplace']).lower()

    for mp in mpall:
        # create lowercase string from name and birthplace
        mpname = '%s %s -- %s' % (mp['firstname'], mp['lastname'], mep['bornplace'])
        mpname = mpname.lower()

        # calculate distance with least-common-string function from febrl
        dist = lcs(mepname, mpname)

        # reset match value if current distance exceeds any previous
        if maxdist <= dist:
            maxdist = dist
            mpmatch = (mp['id'], mpname)

    print round(maxdist,2), ' -- ', mpmatch[1], ' ', mepname

    # write results for current mep into file
    f.write( ','.join((mep['id'], mepname, str(dist)) + mpmatch) + '\n')

f.close()
